# This file should contain Python code, not HTML/JavaScript.
# Example: Calculate and print values for HDGL channels.

import math

class HDGL:
    phi = 1.6180339887
    phi_phi = 2.6180339887
    P3 = 4.2360679775
    P7 = 29.0344465435
    recursionActive = False

    @classmethod
    def compute_channels(cls, t):
        phi_val = cls.phi * math.sin(t * cls.phi)
        phi_phi_val = cls.phi_phi * math.sin(t * cls.phi_phi)
        P3_val = cls.P3 * math.sin(t * cls.P3)
        rec_val = cls.phi * math.sin(t * cls.phi) + cls.phi_phi * math.cos(t * cls.phi_phi)
        if cls.recursionActive:
            rec_val *= cls.P7 / cls.P3
        return {
            "phi": phi_val,
            "phi_phi": phi_phi_val,
            "P3": P3_val,
            "recursion": rec_val
        }

if __name__ == "__main__":
    t = 0.0
    for i in range(10):
        t += 0.05
        channels = HDGL.compute_channels(t)
        print(f"t={t:.2f} | phi={channels['phi']:.4f} | phi_phi={channels['phi_phi']:.4f} | P3={channels['P3']:.4f} | recursion={channels['recursion']:.4f}")